/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.mc.text;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import icyllis.modernui.ModernUI;
import icyllis.modernui.graphics.text.Font;
import icyllis.modernui.mc.ModernUIMod;
import icyllis.modernui.mc.text.TextLayout;
import icyllis.modernui.mc.text.TextLayoutEngine;
import net.minecraft.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ComponentArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;

public class MuiTextCommand {
    public static final ResourceLocation JB_MONO = ModernUIMod.location("jetbrains-mono-medium");

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"modernui").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"text").then(Commands.m_82127_((String)"layout").then(Commands.m_82129_((String)"message", (ArgumentType)ComponentArgument.m_87114_()).executes(ctx -> {
            MuiTextCommand.layout((CommandSourceStack)ctx.getSource(), ComponentArgument.m_87117_((CommandContext)ctx, (String)"message"));
            return 1;
        })))).then(Commands.m_82127_((String)"splitLines").then(Commands.m_82129_((String)"width", (ArgumentType)FloatArgumentType.floatArg((float)0.0f)).then(Commands.m_82129_((String)"message", (ArgumentType)ComponentArgument.m_87114_()).executes(ctx -> {
            MuiTextCommand.splitLines((CommandSourceStack)ctx.getSource(), ComponentArgument.m_87117_((CommandContext)ctx, (String)"message"), FloatArgumentType.getFloat((CommandContext)ctx, (String)"width"));
            return 1;
        }))))));
    }

    private static void layout(CommandSourceStack source, Component component) {
        TextLayout layout = TextLayoutEngine.getInstance().lookupFormattedLayout((FormattedText)component, Style.f_131099_, 5);
        StringBuilder b = new StringBuilder();
        char[] chars = layout.getTextBuf();
        b.append("chars (logical order): ").append(chars.length).append('\n');
        float[] advances = layout.getAdvances();
        b.append("advances (normalized, cluster-based, logical order)\n");
        b.append("LB=line break, GB=grapheme break, NB=non-breaking\n");
        int[] lineBoundaries = layout.getLineBoundaries();
        int lineBoundaryIndex = 0;
        int nextLineBoundary = lineBoundaries[lineBoundaryIndex++];
        int i = 0;
        while (i < chars.length) {
            int j;
            b.append(String.format(" %04X ", i));
            int lim = Math.min(i + 8, chars.length);
            for (j = i; j < lim; ++j) {
                b.append(String.format("\\u%04X", chars[j]));
            }
            b.append("\n      ");
            for (j = i; j < lim; ++j) {
                b.append(String.format(" %5.1f", Float.valueOf(advances[j])));
            }
            b.append("\n      ");
            for (j = i; j < lim; ++j) {
                if (j == nextLineBoundary) {
                    b.append("LB    ");
                    nextLineBoundary = lineBoundaries[lineBoundaryIndex++];
                    continue;
                }
                if (advances[j] != 0.0f) {
                    b.append("GB    ");
                    continue;
                }
                b.append("NB    ");
            }
            b.append('\n');
            i = lim;
        }
        int[] glyphs = layout.getGlyphs();
        b.append("glyphs (font/slot/glyph, visual order): ").append(glyphs.length).append('\n');
        float[] positions = layout.getPositions();
        byte[] fontIndices = layout.getFontIndices();
        b.append("positions (normalized x/y, visual order)\n");
        int[] glyphFlags = layout.getGlyphFlags();
        b.append("B=bold, I=italic, U=underline, S=strikethrough\n");
        b.append("O=obfuscated, E=color emoji, M=embedded bitmap\n");
        int i2 = 0;
        while (i2 < glyphs.length) {
            int j;
            b.append(String.format(" %04X ", i2));
            int lim = Math.min(i2 + 4, glyphs.length);
            for (j = i2; j < lim; ++j) {
                int idx = fontIndices == null ? 0 : fontIndices[j] & 0xFF;
                b.append(String.format(" %02X %02X %04X ", idx, glyphs[j] >>> 24, glyphs[j] & 0xFFFF));
            }
            b.append("\n      ");
            for (j = i2; j < lim; ++j) {
                b.append(String.format("%6.1f,%4.1f ", Float.valueOf(positions[j << 1]), Float.valueOf(positions[j << 1 | 1])));
            }
            b.append("\n      ");
            for (j = i2; j < lim; ++j) {
                int flag = glyphFlags[j];
                b.append(' ');
                TextLayout.toFlagString(b, flag);
                b.append("    ");
            }
            b.append('\n');
            i2 = lim;
        }
        Font[] fonts = layout.getFontVector();
        for (int i3 = 0; i3 < fonts.length; ++i3) {
            b.append(String.format(" %02X: %s\n", i3, fonts[i3].getFamilyName()));
        }
        b.append("total advance: ");
        b.append(layout.getTotalAdvance());
        b.append('\n');
        String result = b.toString();
        source.m_243053_(component);
        source.m_243053_((Component)Component.m_237113_((String)result).m_6270_(Style.f_131099_.m_131150_(JB_MONO)));
        Util.m_183992_().execute(() -> ModernUI.LOGGER.info(TextLayoutEngine.MARKER, result));
    }

    private static void splitLines(CommandSourceStack source, Component component, float width) {
        MutableComponent b = Component.m_237119_();
        int[] lineNum = new int[]{0};
        TextLayoutEngine.getInstance().getStringSplitter().computeLineBreaks((FormattedText)component, width, Style.f_131099_, (line, notFirstLine) -> {
            String lineString = line.getString();
            int len = lineString.length();
            Object[] objectArray = new Object[3];
            int n = lineNum[0];
            lineNum[0] = n + 1;
            objectArray[0] = n;
            objectArray[1] = len;
            objectArray[2] = notFirstLine;
            b.m_7220_((Component)Component.m_237113_((String)String.format("Line %d, chars: %d, inWrappedLine: %b\nText: ", objectArray)).m_6270_(Style.f_131099_.m_131150_(JB_MONO)));
            b.m_130946_(lineString);
            StringBuilder ib = new StringBuilder();
            ib.append("\nUTF16: ");
            for (int i = 0; i < len; ++i) {
                ib.append("\\u");
                String s = Integer.toHexString(lineString.charAt(i));
                ib.append("0".repeat(4 - s.length()));
                ib.append(s);
            }
            ib.append('\n');
            b.m_7220_((Component)Component.m_237113_((String)ib.toString()).m_6270_(Style.f_131099_.m_131150_(JB_MONO)));
        });
        String result = b.getString();
        source.m_243053_(component);
        source.m_243053_((Component)b);
        Util.m_183992_().execute(() -> ModernUI.LOGGER.info(TextLayoutEngine.MARKER, result));
    }
}

